﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="StationDivisionAuthorization.aspx.cs" Inherits="VIRP_WEB.Common.StationDivisionAuthorization" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript" language="javascript">
        var sentillionDesc = "<% Response.Write(SentillionReasonDesc); %>";
        var sentillionCode = "<% Response.Write(SentillionReasonCode); %>";
        var contextDesc = "<% Response.Write(ContextReasonDesc); %>";
        var contextCode = "<% Response.Write(ContextReasonCode); %>";
        var requestStationAction = "<% Response.Write(RequestStationAction); %>";
        var confirmAction = "<% Response.Write(ConfirmAction); %>";
        var actionQueryField = "<% Response.Write(ActionQueryField); %>";
        var vistaQueryField = "<% Response.Write(VistaQueryField); %>";
        var reasonQueryField = "<% Response.Write(ReasonQueryField); %>";
    </script>

    <asp:Literal runat="Server" ID="DefaultJavascript">

<object id="ContextorControl" data="data:application/x-oleobject;base64,96x4h6lc0xGHJwBgsLXhNwADAADYEwAA2BMAAA=="
	classid="CLSID:8778ACF7-5CA9-11D3-8727-0060B0B5E137" name="ContextorControl" >
</object>

<script type="text/javascript" language="JavaScript" for="window" event="onLoad()">
    startSentillion();
</script>

<script type="text/javascript" language="javascript">

    var foundID = null;
    var action = null;
    var reason = null;

    function startSentillion()
    {
        addToDisplay("***Initializing Sign-On***", "");
        addToDisplay("Attempting to bind to user context...", "");
        //Give the UI thread time to draw the screen, then actually startup Sentillion.
        setTimeout(delayedStartSentillion, 100);
    }

    function delayedStartSentillion() {
        appcode = ""
        appname = "CCOWDisplayer#"
        surveyable = true;
        try {
            ContextorControl.Run(appname, appcode, surveyable);
        } catch (errorObject) {
            //The Sentillion components were not found. Show an error and the site selection box.
            addToDisplay("Sentillion Components", sentillionDesc);
            addToDisplay("Please wait...", "");
            action = requestStationAction;
            reason = sentillionCode;
            setTimeout(ContinueToApplication, 100);
            return;
        }
        processContext(ContextorControl.CurrentContext);
    }

    function addToDisplay(key, value) {
        var row = logTable.insertRow(logTable.rows.length);
        var cell = row.insertCell(0);
        cell.innerHTML = key;
        if (value != null && value.length > 0) {
            addToDisplay(value, "");
        }
    }

    function processContext(contextItems) {
        try {
            var coll = new Enumerator(contextItems);
            var contextValues = "<br>CPRS/CCOW Parameters";

            if (coll.atEnd()) {
                //The Sentillion components were found but there is no context.
                action = requestStationAction;
                reason = contextCode;
                setTimeout(ContinueToApplication, 100);

                addToDisplay("No Context Found", "Application must be invoked from CPRS. Attempting to use site from CPRS");
                //LogNoContextFound();
                return;
            }
            //The Sentillion components were found and there is context.
            for (; !coll.atEnd() ; coll.moveNext()) {
                var itemName = coll.item().name;
                var itemValue = coll.item().value;

                contextValues += "<BR>" + itemName + ":" + itemValue + "::";

                if (itemName == "user.id.logon.vistalogon")
                {
                    //We have everything we need to test the user credentials.
                    addToDisplay("Login found", "Verifying Connection to VIA Service");
                    action = confirmAction;
                    foundID = itemValue;
                    setTimeout(ContinueToApplication, 100);

                    addToDisplay(contextValues);

                    return;
                }
            }

            // If we make it here, show what we got from CPRS
            contextValues += "<BR><BR>";
            addToDisplay(contextValues);

            //The Sentillion components were found but the field we need was not found in the context. Show the station selection box.
            addToDisplay("Login not found", contextDesc);
            addToDisplay("Please wait...", "");
            action = requestStationAction;
            reason = contextCode;
            setTimeout(ContinueToApplication, 100);
        } catch (errorObject) {
            addToDisplay(errorObject.message, errorObject.description);
        }
    }

    function GetBaseLocation() {
        var loc = new String(window.location);
        var found = loc.indexOf('?', 0);
        if (found > 0)
            loc = loc.substring(0, found - 1);
        found = loc.indexOf('#');
        if (found > 0)
            loc = loc.substring(0, found - 1);
        return loc;
    }

    //function LogNoContextFound() {
    //    try
    //    {
    //        var loc = GetBaseLocation();
    //        var req = new XMLHttpRequest();
    //        req.open("POST", loc);
    //        req.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
    //        req.send("Error: No Context Found");
    //    }
    //    catch (x) {
    //        //if it doesn't make it to the log there's not much we can do - already displaying error to user
    //    }
    //}

    function ContinueToApplication()
    {
        var loc = GetBaseLocation();
        window.navigate(window.location + "?"+ actionQueryField +"=" + action + "&" + vistaQueryField+ "=" + foundID + "&" + reasonQueryField + "=" + reason);
    }
</script>

    </asp:Literal>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:Literal runat="Server" id="DefaultCCOWContent">
        <table id="logTable" style="max-width: 800px; margin-left: auto; margin-right: auto; margin-top: auto; margin-bottom: auto;text-align:center;">
            <tr>
                <td>
                    <h2 style="text-align: center;">Determining Station Division</h2>
                </td>
            </tr>
            <tr>
                <td>
                    <h3 style="text-align: center;">Status</h3>
                </td>
            </tr>
        </table>
    </asp:Literal>
    <asp:Panel runat="server" id="SelectionContent">
        <table style="max-width: 800px; margin-left: auto; margin-right: auto; margin-top: auto; margin-bottom: auto;text-align:center;">
            <tr><td><h2>Unable to Perform Single Sign On</h2></td></tr>
            <tr><td><asp:Label runat="server" id="ErrorLabel" /></td></tr>
            <tr><td><asp:Label runat="server" id="ExtendedErrorLabel" /></td></tr>
            <tr><td>&nbsp;</td></tr>
            <tr><td><asp:Label runat="server" id="InstructionsLabel" /></td></tr>
<%--            <tr><td><asp:ListBox runat="server" id="StationBox" SelectionMode="Single" Height="150" DataTextField="Description" DataValueField="Code" /></td></tr>
            <tr><td><asp:Button runat="server" id="SubmitButton" onclick="SubmitButton_Click" Text="Submit" /></td></tr>--%>
        </table>
    </asp:Panel>
</asp:Content>
